<?php
/*
	Functions for enqueing styles and scripts
*/

function redoak_enqueue_style() {
	wp_enqueue_style( 'core', get_template_directory_uri() . '/style.css', false );
	wp_enqueue_style( 'redoak_styles', get_template_directory_uri() . '/css/style.css', false );
  	wp_enqueue_style( 'opensans', '//fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic,700italic', false );
	wp_enqueue_style( 'materialicons', '//fonts.googleapis.com/icon?family=Material+Icons', false );
}

function redoak_enqueue_script() {
	wp_enqueue_script( 'js', get_template_directory_uri() . '/js/js.js', array('jquery') );
}

add_action( 'wp_enqueue_scripts', 'redoak_enqueue_style' );
add_action( 'wp_enqueue_scripts', 'redoak_enqueue_script' );

// For comment replies
function redoak_load_comment_script(){
    if ( ( ! is_admin() ) && is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_print_scripts', 'redoak_load_comment_script' );

?>
