<?php

// Customizer
function redoak_customize_register( $wp_customize ) {

    $wp_customize->add_section( 'redoak_theme_mods', array(
        'title' => __( 'Red Oak Options' ),
        'description' => __( 'Customize your site here.' ),
        'panel' => '', // Not typically needed.
        'priority' => 160,
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
      ) );

    $wp_customize->add_setting( 'redoak_theme_logo', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    // $wp_customize->add_control( 'redoak_theme_logo', array(
    //     'type' => 'url',
    //     'mime_type' => 'image',
    //     'priority' => 0, // Within the section.
    //     'section' => 'redoak_theme_mods', // Required, core or custom.
    //     'label' => __( 'Site Logo', 'redoak' ),
    //     'description' => __( 'Recommended: An image at least 300x300 with a transparent background. PNG', 'redoak' )
    // ) );

    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'redoak_theme_logo_control', array(
        'label' => 'Theme Logo',
        'settings'  => 'redoak_theme_logo',
        'section'   => 'redoak_theme_mods',
        'description' => __( 'Recommended: An image at least 300x300 with a transparent background. PNG', 'redoak' )
    ) ));


    

    $wp_customize->add_setting( 'redoak_theme_brand_color', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'redoak_theme_brand_color_control', array(
        'label' => 'Brand Color',
        'settings'  => 'redoak_theme_brand_color',
        'section'   => 'redoak_theme_mods',
        'description' => __( 'Choose a color that will be used for the top bar and all links', 'redoak' )
    ) ));
    
    // $wp_customize->add_setting( 'redoak_darkmode', array(
    //     'type' => 'theme_mod', // or 'option'
    //     'capability' => 'edit_theme_options',
    //     'theme_supports' => '', // Rarely needed.
    //     'default' => '',
    //     'transport' => 'refresh', // or postMessage
    //     'sanitize_callback' => '',
    //     'sanitize_js_callback' => '' // Basically to_json.
    // ) );

    // $wp_customize->add_control( 'redoak_darkmode', array(
    //     'type' => 'checkbox',
    //     'priority' => 10, // Within the section.
    //     'section' => 'redoak_theme_mods', // Required, core or custom.
    //     'label' => __( 'Dark Mode' ),
    //     'description' => __( 'Toggle the contrast of your web site on or off.', 'redoak' )
    // ) );

    // Frontpage settings


    $wp_customize->add_setting( 'redoak_social_facebook', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'redoak_social_facebook', array(
        'type' => 'text',
        'priority' => 20, // Within the section.
        'section' => 'redoak_theme_mods', // Required, core or custom.
        'label' => __( 'Facebook URL', 'redoak' ),
        'description' => __( 'E.g. https://facebook.com/YOURNAME', 'redoak' )
    ) );

    $wp_customize->add_setting( 'redoak_social_twitter', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'redoak_social_twitter', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'redoak_theme_mods', // Required, core or custom.
        'label' => __( 'Twitter URL', 'redoak' ),
        'description' => __( 'E.g. https://twitter.com/YOURNAME', 'redoak' )
    ) );

    $wp_customize->add_setting( 'redoak_social_microblog', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'redoak_social_microblog', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'redoak_theme_mods', // Required, core or custom.
        'label' => __( 'Micro.blog URL', 'redoak' ),
        'description' => __( 'E.g. https://micro.blog/YOURNAME', 'redoak' )
    ) );

    $wp_customize->add_setting( 'redoak_social_instagram', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'redoak_social_instagram', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'redoak_theme_mods', // Required, core or custom.
        'label' => __( 'Instagram URL' ),
        'description' => __( 'E.g. https://instagram.com/YOURNAME' )
    ) );

    $wp_customize->add_setting( 'redoak_social_linkedin', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'redoak_social_linkedin', array(
        'type' => 'text',
        'priority' => 40, // Within the section.
        'section' => 'redoak_theme_mods', // Required, core or custom.
        'label' => __( 'LinkedIn URL', 'redoak' ),
        'description' => __( 'E.g. https://linkedin.com/YOURNAME', 'redoak' )
    ) );



    
    // Footer Text
    $wp_customize->add_setting( 'redoak_footer_text', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => 'Website theme <a href="http://cdevroe.com/projects/redoak">Red Oak on WordPress</a>.',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'redoak_footer_text', array(
        'type' => 'text',
        'priority' => 50, // Within the section.
        'section' => 'redoak_theme_mods', // Required, core or custom.
        'label' => __( 'Footer Text' ),
        'description' => __( 'Shown at the bottom of each page.', 'redoak' ),
        'input_attrs' => array(
          'placeholder' => __( 'Powered by WordPress and coffee.', 'redoak' ),
        )
      ) );
}
add_action( 'customize_register', 'redoak_customize_register' );