<?php if ( get_post_format() != 'status' && get_post_format() != 'image' ) : ?>
    <h2><a href="<?php the_permalink(); ?>" title="Link to post"><?php the_title(); ?></a></h2>
    <div class="meta">
        <span class="meta-publish-date">
            <i class="material-icons">schedule</i> <?php echo get_the_date(); ?> <?php comments_popup_link( '' , __('<i class="material-icons">comment</i> 1 Comment', 'redoak'), '<i class="material-icons">comment</i> % ' . __('Comments', 'redoak'), '', '' ); ?>
        </span>
    </div>
    <span>
        <?php the_content(); ?>
    </span>
    <?php if ( is_single() ) : ?>
        <div class="meta">
        <?php // Show the categories in a comma list but only if the post isn't in Uncategorized cuz that is messy
        $categories = get_the_category();
        if ( $categories[0]->name != 'Uncategorized' ) : ?>
            <p><?php the_category( ', ' ); ?></p>
        <?php endif; ?>
            <p><?php the_tags(); ?></p>
        </div>
    <?php endif; ?>
<?php else : ?>
    <span>
        <?php the_content(); ?>
    </span>
    <div class="meta">
        <span class="meta-publish-date">
            <i class="material-icons">schedule</i> <a href="<?php the_permalink(); ?>" title="Link to post"><?php echo get_the_date(); ?></a> <?php comments_popup_link( '' , __('<i class="material-icons">comment</i> 1 Comment', 'redoak'), '<i class="material-icons">comment</i> % ' . __('Comments', 'redoak'), '', '' ); ?>
        </span>
    </div>

    <?php
        $categories = get_the_category();
        $show_categories = ($categories[0]->name != 'Uncategorized') ? true : false;
    
        if ( is_single() && ( $show_categories || has_tag() ) ) : ?>
        <div class="meta">
        <?php // Show the categories in a comma list but only if the post isn't in Uncategorized cuz that is messy
        if ( $show_categories ) : ?>
            <p><?php the_category( ', ' ); ?></p>
        <?php endif; ?>
            <p><?php the_tags(); ?></p>
        </div>
    <?php endif; ?>
<?php endif; ?>