<?php
/*

	Photo Custom Post Type
*/

add_action( 'init','photos_register' );
function photos_register() {

    $args = array(
        'label' => __( 'Photos' ),
        'labels' => array('name'  => _x( 'Photos', 'Post type general name', 'redoak' ),
          'singular_name'         => _x( 'Photo', 'Post type singular name', 'redoak' ),
          'menu_name'             => _x( 'Photos', 'Admin Menu text', 'redoak' ),
          'name_admin_bar'        => _x( 'Photo Post', 'Add New on Toolbar', 'redoak' ),
          'add_new'               => __( 'Add New', 'redoak' ),
          'add_new_item'          => __( 'Add New Photo Post', 'redoak' ),
          'new_item'              => __( 'New Photo Post', 'redoak' ),
          'edit_item'             => __( 'Edit Photo Post', 'redoak' ),
          'view_item'             => __( 'View Photo Post', 'redoak' ),
          'all_items'             => __( 'All Photo Posts', 'redoak' ),
          'search_items'          => __( 'Search Photo Posts', 'redoak' ),
          'parent_item_colon'     => __( 'Parent Photo Posts:', 'redoak' ),
          'not_found'             => __( 'No photo posts found.', 'redoak' ),
          'not_found_in_trash'    => __( 'No photo posts found in Trash.', 'redoak' ),
          'featured_image'        => _x( 'Photo Post Cover Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'redoak' ),
          'set_featured_image'    => _x( 'Set featured image', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', 'redoak' ),
          'remove_featured_image' => _x( 'Remove featured image', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', 'redoak' ),
          'use_featured_image'    => _x( 'Use as featured image', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', 'redoak' ),
          'archives'              => _x( 'Photo archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', 'redoak' ),
        ),
        'show_in_rest' => true,
        'public' => true,
        'show_ui' => true,
        'capability_type' => 'post',
        'hierarchical' => true,
        'has_archive' => true,
        'supports' => array( 'title', 'editor', 'thumbnail', 'excerpt', 'custom-fields', 'revisions', 'page-attributes' ),
        'rewrite' => array( 'slug' => 'photos', 'with_front' => false ),
       );

    register_post_type( 'photos' , $args );

    register_taxonomy( "photos_category",
              array( 'photos' ),
              array( "hierarchical" => true,
                  "label" => "Photo Categories",
                  "singular_label" => "Photo Category",
                  "rewrite" => true,
                  "show_in_rest" => true,
                  "slug" => 'photos_categories',
                )
      );

      register_taxonomy( "photos_tag",
                array( 'photos' ),
                array( "hierarchical" => false,
                    "label" => "Photo Tags",
                    "singular_label" => "Photo Tag",
                    "show_in_rest" => true,
                    "rewrite" => true,
                    "slug" => 'photos_tags',
                  )
        );
}

?>
