<?php get_header(); ?>
<?php get_sidebar(); ?>
<main>
	<section class="portfolio-header">
		<header>
			<h2><?php the_archive_title(); ?></h2>
			<nav>
				<ul>
					<!-- <li><a href="#"><i class="fa fa-share"></i></a></li> -->
					<li><a href="#" class="drop-link" data-nav="categories">Categories</a></li>
					<li><a href="#" class="drop-link" data-nav="search"><i class="material-icons">search</i></a></li>
					<li><a href="<?php echo home_url(); ?>/feed"><i class="material-icons">rss_feed</i></a></li>
				</ul>
			</nav>
		</header>
		<div class="blog-controls">
			<section data-nav-content="categories">
				<?php if ( $category_list = get_categories( array('taxonomy' => 'portfolio_category')) ) { ?>
					<ul>
						<?php foreach($category_list as $category) :
							echo '<li><a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->name ) . '</a></li>';
						endforeach; ?>
					</ul>
				<?php } // end category list ?>
				<a href="#" class="close-link material-icons">close</a>
			</section>
			<section data-nav-content="search" class="blog-search">
				<form id="barley-search" method="get" role="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<input class="form-control" type="search" id="searchtext" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
					<button class="button" type="submit">
						<i class="material-icons">arrow_forward</i>
					</button>
				</form>
				<a href="#" class="close-link material-icons">close</a>
			</section>
		</div>
	</section>
	<section>
	<div class="container">
					<div class="row">
						<div class="grid thumbnails" data-toggle="lightbox">
							<div class="grid-sizer"></div>
							<?php if ( have_posts() ) :
		                        while ( have_posts() ) : the_post();
                            		$featured_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
									<div class="item">
										<figure>
											<img src="<?php echo $featured_image[0]; ?>">
											<div class="overlay">
												<!-- <a title="<?php the_title(); ?>" href="#" class="thumbnail">
													<i class="material-icons">zoom_out_map</i>
												</a> -->
												<a href="<?php echo get_the_permalink( $post->ID ); ?>" class="more-link">
													<i class="material-icons">arrow_forward</i>
												</a>
											</div>
										</figure>
									</div>
								<?php
								endwhile;
								else : ?>
									<p><?php echo __('No posts yet. Please check back another time.','cypress'); ?></p>
								<?php endif; ?>
						</div>
					</div>
				</div>
	</section>
	<section class="pagination">
		<nav>
			<?php if ( previous_posts_link() ) : ?><?php previous_posts_link('Newer Posts'); ?><?php endif; ?>
			<?php if ( next_posts_link() ) : ?><?php next_posts_link('Older Posts'); ?><?php endif; ?>
		</nav>
	</section>
	<footer>
	<div>
		<p><?php echo get_theme_mod( 'cypress_footer_text' ); ?></p>
	</div>
</footer>
</main>
<?php
get_footer(); ?>
