<?php
function cypress_setup() {

    // JavaScripts and Stylesheets
    include('functions-scripts.php');

    // Portfolio Custom Post Type
    include('functions-type-portfolio.php');

    // Comments and Webmentions
    include('functions-comments.php');

    // WordPress Customizer
    include('functions-customizer.php');

    // Index Functions
    include('functions-index.php');

    // Theme Update API
    include('functions-widgets.php');

    // Weird WordPress things.
    add_theme_support( 'post-thumbnails' , array('post', 'page', 'portfolio') );
    add_theme_support( 'html5', array('gallery','search-form') );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'post-formats', array( 'status', 'audio', 'image' ) );
    add_theme_support( 'title-tag' );
    add_theme_support( 'responsive-embeds' );

    // Register menu
    register_nav_menus(array(
        'primary-menu' => __('Primary Menu')
    ));

}
add_action( 'after_setup_theme', 'cypress_setup' );

// Theme Update API
include('functions-theme-update.php');
?>
