<?php
/*
    Functions to create /index
    Based on Piper Haywood's Index https://piperhaywood.com/index/
    Code from Piper on Github: https://github.com/piperhaywood/commonplace-wp-theme/blob/master/commonplace-theme/functions.php#L52 
*/

function cp_get_years_array() {
    global $wpdb;
    $result = array();
    $years = $wpdb->get_results(
      $wpdb->prepare(
        "SELECT YEAR(post_date) FROM {$wpdb->posts} WHERE post_status = %s GROUP BY YEAR(post_date) DESC",
        array('publish')
      ),
      ARRAY_N
    );
    if (is_array($years) && count($years) > 0) {
      foreach ($years as $year) {
        $result[] = $year[0];
      }
    }
    return $result;
  }

  function cp_add_to_index($groups, $args) {
    $first_char = strtoupper($args['name'][0]);
    if (is_numeric($first_char)) {
      $first_char = '#';
    } elseif (mb_detect_encoding($first_char) == 'UTF-8') {
      $first_char = '?';
    }
    $groups[$first_char][$args['slug']] = $args;
    return $groups;
  }

function get_notebook_index($taxonomy, $showYears, $count) {
  // Set up the index groups
  $groups = array();

  // Add the year archives to the index
  if ($showYears) {
    $years = cp_get_years_array();
    if ($years) {
      $args = array(
        'posts_per_page' => -1,
        'post_type' => 'post',
        'fields' => 'ids'
      );
      foreach ($years as $year) {
        $args['date_query'] = array(
          array('year' => $year)
        );
        $posts = get_posts($args);
        $yearCount = count($posts);
        if ($yearCount >= $count ) {
          $groups = cp_add_to_index($groups, array(
            'name' => $year,
            'url' => get_year_link($year),
            'count' => $yearCount,
            'slug' => $year,
            'type' => 'year',
            'aria' => sprintf(esc_html__('Year: %s, %s posts', 'notebook-ph'), $year, $yearCount)
          ));
        }
      }
    }
  }

  // Add the terms to the index
  $terms = get_terms(array(
    'taxonomy' => $taxonomy
  ));
  if ($terms && is_array($terms)) {
    foreach ($terms as $term) {
      if ($term->count >= $count) {
        // NOTE strip "post-format-" from slug, for some reason this gets included
        $slug = str_replace('post-format-', '', $term->slug);
        $tax = get_taxonomy($term->taxonomy);
        $groups = cp_add_to_index($groups, array(
          'name' => $term->name,
          'url' => get_tag_link($term->term_id),
          'count' => $term->count,
          'slug' => $slug,
          'type' => $term->taxonomy,
          'aria' => sprintf(esc_html__('%s: %s, %s posts', 'notebook-ph'), $tax->labels->singular_name, $term->name, $term->count)
        ));
      }
    }
  }

  
  ob_start(); ?>
    <?php if (!empty($groups)) : ?>
      <div class="termindex">
        <?php foreach ($groups as $char => $terms) : ?>
          <?php ksort($terms); ?>
          <?php $label = $char == '#' ? esc_attr__('a number', 'notebook-ph') : $char; ?>
          <?php $label = sprintf(esc_attr__('Terms beginning with %s', 'notebook-ph'), $label); ?>
          <div class="termgroup">
            <h2 aria-label="<?php echo $label; ?>"><?php echo apply_filters( 'the_title', $char ); ?></h2>
            <ol>
            <?php foreach ($terms as $slug => $term) : ?>
              <li>
                <a aria-label="<?php echo $term['aria']; ?>" href="<?php echo $term['url']; ?>"><span class="term term--<?php echo $term['type']; ?>"><?php echo $term['name']; ?></span>&nbsp;<span class="term__count"><?php echo $term['count']; ?></span></a>
              </li>
            <?php endforeach; ?>
            </ol>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  <?php return ob_get_clean();
}

add_shortcode('notebookindex', 'notebook_index');
function notebook_index($attr) {
  $a = shortcode_atts(array(
    'taxonomy' => 'post_tag, category, post_format',
    'years' => 'true',
    'count' => '1',
  ), $attr);
  $taxonomy = explode(',', str_replace(', ', ',', $a['taxonomy']));
  $showYears = ($a['years'] === 'true');
  $count = intval($a['count']);
  return get_notebook_index($taxonomy, $showYears, $count);
}