<?php

// Customizer
function cypress_customize_register( $wp_customize ) {

    $wp_customize->add_section( 'cypress_theme_mods', array(
        'title' => __( 'Cypress Options' ),
        'description' => __( 'Customize your site here.' ),
        'panel' => '', // Not typically needed.
        'priority' => 160,
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
      ) );

    $wp_customize->add_setting( 'cypress_theme_logo', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    // $wp_customize->add_control( 'cypress_theme_logo', array(
    //     'type' => 'url',
    //     'mime_type' => 'image',
    //     'priority' => 0, // Within the section.
    //     'section' => 'cypress_theme_mods', // Required, core or custom.
    //     'label' => __( 'Site Logo', 'cypress' ),
    //     'description' => __( 'Recommended: An image at least 300x300 with a transparent background. PNG', 'cypress' )
    // ) );

    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'cypress_theme_logo_control', array(
        'label' => 'Site Logo',
        'settings'  => 'cypress_theme_logo',
        'section'   => 'cypress_theme_mods',
        'description' => __( 'Recommended: An image at least 300x300 with a transparent background. PNG', 'cypress' )
    ) ));
    
    $wp_customize->add_setting( 'cypress_darkmode', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_darkmode', array(
        'type' => 'checkbox',
        'priority' => 10, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Dark Mode' ),
        'description' => __( 'Toggle the contrast of your web site on or off.', 'cypress' )
    ) );

    // Frontpage settings

    // Show header
    $wp_customize->add_setting( 'cypress_frontpage_showheader', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_frontpage_showheader', array(
        'type' => 'checkbox',
        'priority' => 10, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Show page header on front page?' ),
        'description' => __( 'Toggle the header to show categories, search, etc. on frontpage on or off.', 'cypress' )
    ) );

    // Show Image Count
    $wp_customize->add_setting( 'cypress_frontpage_showimagecount', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_frontpage_showimagecount', array(
        'type' => 'checkbox',
        'priority' => 10, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Show image count on portfolio images?' ),
        'description' => __( 'Toggle the image count shown on portfolio posts on or off.', 'cypress' )
    ) );

    // -- SOCIAL ACCOUNTS

        // Facebook
    $wp_customize->add_setting( 'cypress_social_facebook', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_facebook', array(
        'type' => 'text',
        'priority' => 20, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Facebook URL', 'cypress' ),
        'description' => __( 'E.g. https://facebook.com/YOURNAME', 'cypress' )
    ) );

    // Flickr

    $wp_customize->add_setting( 'cypress_social_flickr', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_flickr', array(
        'type' => 'text',
        'priority' => 20, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Flickr URL', 'cypress' ),
        'description' => __( 'E.g. https://flickr.com/photos/USERNAME', 'cypress' )
    ) );

    // Github

    $wp_customize->add_setting( 'cypress_social_github', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_github', array(
        'type' => 'text',
        'priority' => 20, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Github URL', 'cypress' ),
        'description' => __( 'E.g. https://github.com/USERNAME', 'cypress' )
    ) );

    // Instagram

    $wp_customize->add_setting( 'cypress_social_instagram', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_instagram', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Instagram URL' ),
        'description' => __( 'E.g. https://instagram.com/USERNAME' )
    ) );

    // LinkedIn

    $wp_customize->add_setting( 'cypress_social_linkedin', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_linkedin', array(
        'type' => 'text',
        'priority' => 40, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'LinkedIn URL', 'cypress' ),
        'description' => __( 'E.g. https://linkedin.com/USERNAME', 'cypress' )
    ) );

    // Mastodon

    $wp_customize->add_setting( 'cypress_social_mastodon', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_mastodon', array(
        'type' => 'text',
        'priority' => 20, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Mastodon URL', 'cypress' ),
        'description' => __( 'E.g. https://mastodon.social/USERNAME', 'cypress' )
    ) );

    // Micro.blog

    $wp_customize->add_setting( 'cypress_social_microblog', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_microblog', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Micro.blog URL', 'cypress' ),
        'description' => __( 'E.g. https://micro.blog/USERNAME', 'cypress' )
    ) );

    // TikTok

    $wp_customize->add_setting( 'cypress_social_tiktok', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_tiktok', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'TikTok URL' ),
        'description' => __( 'E.g. https://www.tiktok.com/@USERNAME' )
    ) );

    // Twitter

    $wp_customize->add_setting( 'cypress_social_twitter', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_twitter', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Twitter URL', 'cypress' ),
        'description' => __( 'E.g. https://twitter.com/USERNAME', 'cypress' )
    ) );

    // Youtube

    $wp_customize->add_setting( 'cypress_social_youtube', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_youtube', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'YouTube Channel URL' ),
        'description' => __( 'E.g. https://www.youtube.com/channel/ID' )
    ) );


    
    // Footer Text
    $wp_customize->add_setting( 'cypress_footer_text', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => 'Website theme <a href="http://cdevroe.com/projects/cypress">Cypress on WordPress</a>.',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_footer_text', array(
        'type' => 'text',
        'priority' => 50, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Footer Text' ),
        'description' => __( 'Shown at the bottom of each page.', 'cypress' ),
        'input_attrs' => array(
          'placeholder' => __( 'Powered by WordPress and coffee.', 'cypress' ),
        )
      ) );
}
add_action( 'customize_register', 'cypress_customize_register' );