<?php get_header(); ?>
<?php get_sidebar(); ?>
		<main>
		<?php 
		// Frontpage options
		$show_frontpage_header = ( get_theme_mod('cypress_frontpage_showheader') ) ? true : false;
		$show_frontpage_imagecount = ( get_theme_mod('cypress_frontpage_showimagecount') ) ? true : false;
		?>
			<?php if ( $show_frontpage_header ) : ?>
			<section class="portfolio-header">
				<header>
					<h2>Home</h2>
					<nav>
						<ul>
							<!-- <li><a href="#"><i class="fa fa-share"></i></a></li> -->
							<li><a href="#" class="drop-link" data-nav="categories">Categories</a></li>
							<li><a href="#" class="drop-link" data-nav="search"><i class="material-icons">search</i></a></li>
							<li><a href="<?php echo home_url(); ?>/feed"><i class="material-icons">rss_feed</i></a></li>
						</ul>
					</nav>
				</header>
				<div class="blog-controls">
					<section data-nav-content="categories">
						<?php if ( $category_list = get_categories( array('taxonomy' => 'portfolio_category')) ) { ?>
							<ul>
								<?php foreach($category_list as $category) :
									echo '<li><a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->name ) . '</a></li>';
								endforeach; ?>
							</ul>
						<?php } // end category list ?>
						<a href="#" class="close-link material-icons">close</a>
					</section>
					<section data-nav-content="search" class="blog-search">
						<form id="barley-search" method="get" role="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
							<input class="form-control" type="search" id="searchtext" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
							<button class="button" type="submit">
								<i class="material-icons">arrow_forward</i>
							</button>
						</form>
						<a href="#" class="close-link material-icons">close</a>
					</section>
				</div>
			</section>
			<?php endif; ?>
			
			<section>
				<div class="container">
					<div class="row">
						<div class="grid thumbnails" data-toggle="lightbox">
							<div class="grid-sizer"></div>
							<?php $recent_portfolioposts = new WP_Query( array ('post_type' => 'portfolio', 'posts_per_page' => '50', 'order' => 'DESC' ) );
		                    if ( $recent_portfolioposts->have_posts() ) :
		                        while ( $recent_portfolioposts->have_posts() ) : $recent_portfolioposts->the_post();
									$featured_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); 
									
									if ( $show_frontpage_imagecount ) :
										$post_content = get_the_content();
										preg_match_all('/<img [^>]*src=["|\']([^"|\']+)/i', $post_content, $images);

										if ( is_array($images) && isset($images[1][0]) ) :
											$image_count = count($images[1]);
										endif;
									endif;
									
									?>
									<div class="item">
										<figure>
											<img src="<?php echo $featured_image[0]; ?>">

											<?php if ( $show_frontpage_imagecount ) :
											if ( $image_count > 1 ) : ?>
												<div class="image_count"><i class="material-icons">image</i> <?php echo $image_count; ?></div>
											<?php endif;
											endif; ?>
										
											<div class="overlay">
												<!-- <a title="<?php the_title(); ?>" href="#" class="thumbnail">
													<i class="material-icons">zoom_out_map</i>
												</a> -->
												<a href="<?php echo get_the_permalink( $post->ID ); ?>" class="more-link">
													<i class="material-icons">arrow_forward</i>
												</a>
											</div>
										</figure>
									</div>
								<?php
								endwhile;
								else : ?>
									<p><?php echo __('No posts yet. Please check back another time.','cypress'); ?></p>
								<?php endif; ?>
						</div>
					</div>
				</div>
			</section>
			<footer>
			<div>
				<p><?php echo get_theme_mod( 'cypress_footer_text' ); ?></p>
			</div>
		</footer>
		</main>
<?php get_footer(); ?>
