<?php get_header(); ?>
<?php get_sidebar();
if (have_posts()) :
 while ( have_posts() ) : the_post();  ?>

<main <?php post_class( 'post'); ?>>
	<section class="blog-header">
		<header>
			<h2><a href="<?php echo home_url(); ?>/blog">Blog</a></h2>
			<nav>
				<ul>
					<li><a href="<?php echo home_url(); ?>/blog">Recent</a></li>
					<li><a href="#" class="drop-link" data-nav="categories">Categories</a></li>
					<li><a href="#" class="drop-link" data-nav="search"><i class="material-icons">search</i></a></li>
					<li><a href="<?php echo home_url(); ?>/feed"><i class="material-icons">rss_feed</i></a></li>
				</ul>
			</nav>
		</header>
		<div class="blog-controls">
			<section data-nav-content="categories">
				<?php if ( $category_list = wp_list_categories( array('echo' => false, 'style' => 'list', 'title_li' => '')) ) { ?>
					<ul>
						<?php echo $category_list; ?>
					</ul>
				<?php } // end category list ?>
				<a href="#" class="close-link material-icons">close</a>
			</section>
			<section data-nav-content="search" class="blog-search">
				<form id="barley-search" method="get" role="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<input class="form-control" type="search" id="searchtext" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
					<button class="button" type="submit">
						<i class="material-icons">arrow_forward</i>
					</button>
				</form>
				<a href="#" class="close-link material-icons">close</a>
			</section>
		</div>
	</section>
	<section>
		<article <?php post_class('h-entry'); ?>>
			<div class="meta">
				<h5 class="dt-published" datetime="<?php echo get_the_date('Y-m-d g:i:s'); ?>"><?php the_date(); ?></h5>
        		<?php if ( $post_category_list = get_the_category_list() ) { ?>
					<h6>Categories:</h6>
					<div class="categories">
						<?php echo $post_category_list; ?>
					</div>
				<?php } // end category list ?>

				<?php if ( $tag_list = get_the_term_list( get_the_id(), $post->post_type.'_tag', '', ', ', '') ) { ?>
					<h6>Tagged:</h6>
					<div class="tags">
						<p><?php echo $tag_list; ?></p>
					</div>
				<?php } // end tag list ?>
			</div>
			<div class="content">
				<?php the_title('<h2 class="p-name">','</h2>'); ?>
				<div class="e-content">
					<?php the_content(); ?>
				</div>
				
				
			</div>
			<?php comments_template(); ?>
		</article>
	</section>
	<footer>
	<div>
		<p><?php echo get_theme_mod( 'cypress_footer_text' ); ?></p>
	</div>
</footer>
</main>

<?php
endwhile; endif;
get_footer(); ?>
