<?php
/*

	Portfolio Custom Post Type
*/

add_action( 'init','portfolio_register' );
function portfolio_register() {

    $args = array(
        'label' => __( 'Portfolios' ),
        'labels' => array('name'  => _x( 'Portfolios', 'Post type general name', 'cypress' ),
          'singular_name'         => _x( 'Portfolio', 'Post type singular name', 'cypress' ),
          'menu_name'             => _x( 'Portfolio', 'Admin Menu text', 'cypress' ),
          'name_admin_bar'        => _x( 'Portfolio Post', 'Add New on Toolbar', 'cypress' ),
          'add_new'               => __( 'Add New', 'cypress' ),
          'add_new_item'          => __( 'Add New Portfolio Post', 'cypress' ),
          'new_item'              => __( 'New Portfolio Post', 'cypress' ),
          'edit_item'             => __( 'Edit Portfolio Post', 'cypress' ),
          'view_item'             => __( 'View Portfolio Post', 'cypress' ),
          'all_items'             => __( 'All Portfolio Posts', 'cypress' ),
          'search_items'          => __( 'Search Portfolio Posts', 'cypress' ),
          'parent_item_colon'     => __( 'Parent Portfolio Posts:', 'cypress' ),
          'not_found'             => __( 'No portfolio posts found.', 'cypress' ),
          'not_found_in_trash'    => __( 'No portfolio posts found. found in Trash.', 'cypress' ),
          'featured_image'        => _x( 'Portfolio Post Homepage Grid Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'cypress' ),
          'set_featured_image'    => _x( 'Set featured image', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', 'cypress' ),
          'remove_featured_image' => _x( 'Remove featured image', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', 'cypress' ),
          'use_featured_image'    => _x( 'Use as featured image', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', 'cypress' ),
          'archives'              => _x( 'Portfolio archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', 'cypress' ),
        ),
        'show_in_rest' => true,
        'public' => true,
        'show_ui' => true,
        'capability_type' => 'post',
        'hierarchical' => true,
        'has_archive' => true,
        'supports' => array( 'title', 'editor', 'thumbnail', 'excerpt', 'custom-fields', 'revisions', 'page-attributes' ),
        'rewrite' => array( 'slug' => 'portfolio', 'with_front' => false ),
       );

    register_post_type( 'portfolio' , $args );

    register_taxonomy( "portfolio_category",
              array( 'portfolio' ),
              array( "hierarchical" => true,
                  "label" => "Portfolio Categories",
                  "singular_label" => "Portfolio Category",
                  "rewrite" => true,
                  "show_in_rest" => true,
                  "slug" => 'portfolio_categories',
                )
      );

      register_taxonomy( "portfolio_tag",
                array( 'portfolio' ),
                array( "hierarchical" => false,
                    "label" => "Portfolio Tags",
                    "singular_label" => "Portfolio Tag",
                    "show_in_rest" => true,
                    "rewrite" => true,
                    "slug" => 'portfolio_tags',
                  )
        );
}

?>
