<?php get_header(); ?>
<?php get_sidebar(); ?>

<main>
	<section class="blog-header">
		<header>
			<h2>Page not found</h2>
			<nav>
				<ul>
					<li><a href="#" class="drop-link" data-nav="categories">Categories</a></li>
					<li><a href="#" class="drop-link" data-nav="search"><i class="material-icons">search</i></a></li>
				</ul>
			</nav>
		</header>
		<div class="blog-controls">
			<section data-nav-content="categories">
				<?php if ( $category_list = wp_list_categories( array('echo' => false, 'style' => 'list', 'title_li' => '')) ) { ?>
					<ul>
						<?php echo $category_list; ?>
					</ul>
				<?php } // end category list ?>
				<a href="#" class="close-link material-icons">close</a>
			</section>
			<section data-nav-content="search" class="blog-search">
				<form id="barley-search" method="get" role="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<input class="form-control" type="search" id="barley-search-term" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
					<button class="button" type="submit">
						<i class="material-icons">arrow_forward</i>
					</button>
				</form>
				<a href="#" class="close-link material-icons">close</a>
			</section>
		</div>
	</section>
	<section class="search">
		<div class="intro no-results">
			<h3>Sorry, this page does not exist</h3>
			<div><p>Perhaps this page was deleted or it may have never existed. You can try searching below.</p></div>
			<form id="barley-search" method="get" role="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
				<input class="form-control" type="search" id="barley-search-term" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
				<button class="button" type="submit">
					<i class="material-icons">arrow_forward</i>
				</button>
			</form>
		</div>
	</section>
	<footer>
	<div>
		<p><?php echo get_theme_mod( 'cypress_footer_text' ); ?></p>
	</div>
</footer>
</main>

<?php get_footer(); ?>
