<?php get_header(); ?>
<?php get_sidebar();
if (have_posts()) :
 while ( have_posts() ) : the_post();  ?>
<main>
	<section class="portfolio-header">
		<header>
			<h2><a href="<?php echo home_url(); ?>/">Portfolio</a></h2>
			<nav>
				<ul>
					<!-- <li><a href="#"><i class="fa fa-share"></i></a></li> -->
					<li><a href="#" class="drop-link" data-nav="categories">Categories</a></li>
					<li><a href="#" class="drop-link" data-nav="search"><i class="material-icons">search</i></a></li>
					<li><a href="<?php echo home_url(); ?>/feed"><i class="material-icons">rss_feed</i></a></li>
				</ul>
			</nav>
		</header>
		<div class="blog-controls">
			<section data-nav-content="categories">
				<?php if ( $category_list = get_categories( array('taxonomy' => 'portfolio_category')) ) { ?>
					<ul>
						<?php foreach($category_list as $category) :
							echo '<li><a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->name ) . '</a></li>';
						endforeach; ?>
					</ul>
				<?php } // end category list ?>
				<a href="#" class="close-link material-icons">close</a>
			</section>
			<section data-nav-content="search" class="blog-search">
				<form id="barley-search" method="get" role="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<input class="form-control" type="search" id="searchtext" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
					<button class="button" type="submit">
						<i class="material-icons">arrow_forward</i>
					</button>
				</form>
				<a href="#" class="close-link material-icons">close</a>
			</section>
		</div>
	</section>
	<section>
		<div class="image">
			<?php the_content(); ?>
		</div>
	</section>
	<section>
		<article>
			<div class="meta">
				<h5><?php the_date(); ?></h5>

        		<?php if ( $category_list = get_the_term_list( get_the_id(), $post->post_type.'_category', '<ul><li>', '</li><li>', '</li></ul>') ) { ?>
					<h6>Categories:</h6>
					<div class="categories">
						<?php echo $category_list; ?>
					</div>
				<?php } // end category list ?>

				<?php if ( $tag_list = get_the_term_list( get_the_id(), $post->post_type.'_tag', '', ', ', '') ) { ?>
					<h6>Tagged:</h6>
					<div class="tags">
						<p><?php echo $tag_list; ?></p>
					</div>
				<?php } // end tag list ?>

			</div>
			<div class="content">
				<?php the_title('<h2>','</h2>'); ?>
				<div>
					<?php if (has_excerpt()) :
						the_excerpt(); 
					endif; ?>
				</div>
			</div>
		</article>
	</section>
	<footer>
	<div>
		<p><?php echo get_theme_mod( 'cypress_footer_text' ); ?></p>
	</div>
</footer>
</main>
<?php endwhile; endif;
get_footer(); ?>
