<?php get_header(); ?>
<?php get_sidebar(); ?>

<main>
	<section class="blog-header">
		<header>
			<h2>Search results for "<?php echo $s; ?>"</h2>
			<nav>
				<ul>
					<li><a href="<?php echo home_url(); ?>/blog">Recent</a></li>
					<li><a href="#" class="drop-link" data-nav="categories">Categories</a></li>
					<li><a href="#" class="drop-link" data-nav="search"><i class="material-icons">search</i></a></li>
				</ul>
			</nav>
		</header>
		<div class="blog-controls">
			<section data-nav-content="categories">
				<?php if ( $category_list = wp_list_categories( array('echo' => false, 'style' => 'list', 'title_li' => '')) ) { ?>
					<ul>
						<?php echo $category_list; ?>
					</ul>
				<?php } // end category list ?>
				<a href="#" class="close-link material-icons">close</a>
			</section>
			<section data-nav-content="search" class="blog-search">
				<form id="barley-search" method="get" role="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<input class="form-control" type="search" id="barley-search-term" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
					<button class="button" type="submit">
						<i class="material-icons">arrow_forward</i>
					</button>
				</form>
				<a href="#" class="close-link material-icons">close</a>
			</section>
		</div>
	</section>
	<section class="search">
		<?php if (have_posts()) : ?>
		<div class="intro">
			<h3><?php echo $s; ?></h3>
		</div>
		<?php while ( have_posts() ) : the_post(); ?>
				<article>
					<div class="content">
						<?php if ( get_post_format() != 'status' ) : ?>
						<h4>
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							<span><?php echo get_the_date(); ?><?php comments_popup_link( '' , __(' &bull; 1 Comment', 'cypress'), '&bull; % ' . __('Comments', 'cypress'), '', '' ); ?></span>
						</h4>
						<?php else : ?>
							<?php the_content(); ?>
							<span class="status-date"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute( array('echo' => 1, 'post' => get_the_id() ) ); ?> published on <?php echo get_the_date('F j, Y \a\t g:i a'); ?>"><?php echo get_the_date(); ?></a><?php comments_popup_link( '' , __(' &bull; 1 Comment', 'cypress'), '&bull; % ' . __('Comments', 'cypress'), '', '' ); ?></span>
						<?php endif; ?>
					</div>
				</article>
			<?php endwhile; ?>
		<?php else : // No results found ?>
			<div class="intro no-results">
				<h3><?php echo $s; ?></h3>
				<div><p>Didn't find what you were looking for? Try your search again.</p></div>
				<form id="barley-search" method="get" role="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<input class="form-control" type="search" id="barley-search-term" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
					<button class="button" type="submit">
						<i class="material-icons">arrow_forward</i>
					</button>
				</form>
			</div>
		<?php endif; ?>
	</section>
	<section class="pagination">
		<nav>
			<?php if ( previous_posts_link() ) : ?><?php previous_posts_link('Newer Posts'); ?><?php endif; ?>
			<?php if ( next_posts_link() ) : ?><?php next_posts_link('Older Posts'); ?><?php endif; ?>
		</nav>
	</section>
	<footer>
	<div>
		<p><?php echo get_theme_mod( 'cypress_footer_text' ); ?></p>
	</div>
</footer>
</main>

<?php get_footer(); ?>
