var $ = jQuery;
$(document).ready(function(){

    // Run masonry plugin
    var $grid = $('.grid').masonry({
        itemSelector: '.item',
        columnWidth: '.grid-sizer',
        percentPosition: true
    });
    $grid.imagesLoaded().progress( function() {
       $grid.masonry('layout');
    });

    // Replace SVG images with PNG versions if SVG is not supported
    if(!Modernizr.svg) {
        $('img[src*="svg"]').attr('src', function() {
            return $(this).attr('src').replace('.svg', '.png');
        });
    }

    // Lightbox source
    $('.grid.thumbnails figure').each(function(){
        $(this).find('a.thumbnail').attr('href', $(this).find('img').attr('src'));
    });

    // Search show/hide functionality
    $('.search-reveal').click(function(e) {
        e.preventDefault();
        $('.blog-header nav ul').fadeOut(200);
        $('.blog-search').delay(200).fadeIn(300);
    });
    $('.blog-search .search-close').click(function(e) {
        e.preventDefault();
        $('.blog-search').fadeOut(200);
        $('.blog-header nav ul').delay(200).fadeIn(300);
    });

    

    // Toggle for mobile nav & button
    $('.nav-toggle').click(function(e){
        e.preventDefault();
        // Duplicate navigation in mobile menu
        var $clonenav = $('aside header nav ul').clone();
        $(".mobile-menu").append($clonenav);
        $('.mobile-menu').fadeToggle();
        $(this).toggleClass('active');
        $('body').toggleClass('freeze');
    });

    $('button[type="search"]').on('click',function(e){
      $(this).parent('form').submit();
    });

    // Blog Controls
    $('.blog-header header nav ul li a.drop-link, .portfolio-header header nav ul li a.drop-link').on('click',function(e){
        e.preventDefault();
        $('.blog-controls').addClass('active');
    });
    $('.blog-header header a[data-nav], .portfolio-header header a[data-nav]').on('click', function(e) {
        e.preventDefault();
        $(this).addClass('active').parent().siblings().find('[data-nav]').removeClass('active');
        $('.blog-controls').children('[data-nav-content=' + $(this).data('nav') + ']').addClass('active').siblings('[data-nav-content]').removeClass('active');
    });
    $('.blog-controls section a.close-link').on('click', function(e) {
        e.preventDefault();
        $('.blog-controls').removeClass('active');
        $('.blog-header header nav ul li a').removeClass('active');
        $('.blog-controls section').removeClass('active');
    });

});
