<?php get_header(); ?>
<?php get_sidebar();
if (have_posts()) : ?>

<main>
	<section class="blog-header">
		<header>
			<h2><a href="<?php echo home_url(); ?>/blog">Blog</a></h2>
			<nav>
				<ul>
					<li><a href="<?php echo home_url(); ?>/blog">Recent</a></li>
					<li><a href="#" class="drop-link" data-nav="categories">Categories</a></li>
					<li><a href="#" class="drop-link" data-nav="search"><i class="material-icons">search</i></a></a></li>
					<li><a href="<?php echo home_url(); ?>/feed"><i class="material-icons">rss_feed</i></a></li>
				</ul>
			</nav>
		</header>
		<div class="blog-controls">
			<section data-nav-content="categories">
				<?php if ( $category_list = wp_list_categories( array('echo' => false, 'style' => 'list', 'title_li' => '')) ) { ?>
					<ul>
						<?php echo $category_list; ?>
					</ul>
				<?php } // end category list ?>
				<a href="#" class="close-link material-icons">close</a>
			</section>
			<section data-nav-content="search" class="blog-search">
				<form id="barley-search" method="get" role="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<input class="form-control" type="search" id="barley-search-term" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
					<button class="button" type="submit">
						<i class="material-icons">arrow_forward</i>
					</button>
					<a href="#" class="close-link material-icons">close</a>
				</form>
			</section>
		</div>
	</section>
	<section class="h-feed">
		<?php while ( have_posts() ) : the_post(); ?>
		<article class="h-entry">
			<div class="meta">
				<h5>
					<a class="dt-published" datetime="<?php echo get_the_date('Y-m-d g:i:s'); ?>" href="<?php the_permalink(); ?>" title="<?php the_title_attribute( array('echo' => 1, 'post' => get_the_id() ) ); ?> published on <?php echo get_the_date('F j, Y \a\t g:i a'); ?>"><?php echo get_the_date(); ?></a>
				</h5>
				<h6>
					<?php comments_popup_link( '' , __('1 Comment', 'cypress'), '% ' . __('Comments', 'cypress'), '', '' ); ?>
				</h6>
			</div>
			<div class="content">
			<?php if ( get_post_format() != 'status' ) : ?>
				<h2><a href="<?php the_permalink(); ?>" class="p-name"><?php the_title(); ?></a></h2>
			<?php endif; ?>
				<div class="e-content">
					<?php the_content(); ?>
				</div>
				<!-- Might bring this back as an option <a class="more-link" href="<?php the_permalink(); ?>">More...</a> -->
			</div>
		</article>
		<?php endwhile; ?>
		<div class="pagination">
			<?php if ( previous_posts_link() ) : ?><?php previous_posts_link('Newer Posts'); ?><?php endif; ?>
			<?php if ( next_posts_link() ) : ?><?php next_posts_link('Older Posts'); ?><?php endif; ?>
		</div>
	</section>
	<footer>
	<div>
		<p><?php echo get_theme_mod( 'cypress_footer_text' ); ?></p>
	</div>
</footer>
</main>

<?php endif; get_footer(); ?>
