<?php
/*

	Portfolio Custom Post Type
*/

add_action( 'init','portfolio_register' );
function portfolio_register() {

    $args = array(
        'label' => __( 'Portfolios' ),
        'labels' => array('name'  => _x( 'Portfolios', 'Post type general name', 'textdomain' ),
          'singular_name'         => _x( 'Portfolio', 'Post type singular name', 'textdomain' ),
          'menu_name'             => _x( 'Portfolio', 'Admin Menu text', 'textdomain' ),
          'name_admin_bar'        => _x( 'Portfolio Post', 'Add New on Toolbar', 'textdomain' ),
          'add_new'               => __( 'Add New', 'textdomain' ),
          'add_new_item'          => __( 'Add New Portfolio Post', 'textdomain' ),
          'new_item'              => __( 'New Portfolio Post', 'textdomain' ),
          'edit_item'             => __( 'Edit Portfolio Post', 'textdomain' ),
          'view_item'             => __( 'View Portfolio Post', 'textdomain' ),
          'all_items'             => __( 'All Portfolio Posts', 'textdomain' ),
          'search_items'          => __( 'Search Portfolio Posts', 'textdomain' ),
          'parent_item_colon'     => __( 'Parent Portfolio Posts:', 'textdomain' ),
          'not_found'             => __( 'No portfolio posts found.', 'textdomain' ),
          'not_found_in_trash'    => __( 'No portfolio posts found. found in Trash.', 'textdomain' ),
          'featured_image'        => _x( 'Portfolio Post Homepage Grid Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'textdomain' ),
          'set_featured_image'    => _x( 'Set featured image', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', 'textdomain' ),
          'remove_featured_image' => _x( 'Remove featured image', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', 'textdomain' ),
          'use_featured_image'    => _x( 'Use as featured image', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', 'textdomain' ),
          'archives'              => _x( 'Portfolio archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', 'textdomain' ),
        ),
        'show_in_rest' => true,
        'public' => true,
        'show_ui' => true,
        'capability_type' => 'post',
        'hierarchical' => true,
        'has_archive' => true,
        'supports' => array( 'title', 'editor', 'thumbnail', 'excerpt', 'custom-fields', 'revisions', 'page-attributes' ),
        'rewrite' => array( 'slug' => 'portfolio', 'with_front' => false ),
       );

    register_post_type( 'portfolio' , $args );

    register_taxonomy( "portfolio_category",
              array( 'portfolio' ),
              array( "hierarchical" => true,
                  "label" => "Portfolio Categories",
                  "singular_label" => "Portfolio Category",
                  "rewrite" => true,
                  "show_in_rest" => true,
                  "slug" => 'portfolio_categories',
                )
      );

      register_taxonomy( "portfolio_tag",
                array( 'portfolio' ),
                array( "hierarchical" => false,
                    "label" => "Portfolio Tags",
                    "singular_label" => "Portfolio Tag",
                    "show_in_rest" => true,
                    "rewrite" => true,
                    "slug" => 'portfolio_tags',
                  )
        );
}

?>
