<?php

// Customizer
function cypress_customize_register( $wp_customize ) {

    $wp_customize->add_section( 'cypress_theme_mods', array(
        'title' => __( 'Cypress Options' ),
        'description' => __( 'Customize your site here.' ),
        'panel' => '', // Not typically needed.
        'priority' => 160,
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
      ) );

    $wp_customize->add_setting( 'cypress_theme_logo', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    // $wp_customize->add_control( 'cypress_theme_logo', array(
    //     'type' => 'url',
    //     'mime_type' => 'image',
    //     'priority' => 0, // Within the section.
    //     'section' => 'cypress_theme_mods', // Required, core or custom.
    //     'label' => __( 'Site Logo' ),
    //     'description' => __( 'Recommended: An image at least 300x300 with a transparent background. PNG' )
    // ) );

    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'cypress_theme_logo_control', array(
        'label' => 'Site Logo',
        'settings'  => 'cypress_theme_logo',
        'section'   => 'cypress_theme_mods',
        'description' => __( 'Recommended: An image at least 300x300 with a transparent background. PNG' )
    ) ));
    
    $wp_customize->add_setting( 'cypress_darkmode', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_darkmode', array(
        'type' => 'checkbox',
        'priority' => 10, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Dark Mode' ),
        'description' => __( 'Toggle the contrast of your web site on or off.' )
    ) );


    $wp_customize->add_setting( 'cypress_social_facebook', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_facebook', array(
        'type' => 'text',
        'priority' => 20, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Facebook URL' ),
        'description' => __( 'E.g. https://facebook.com/YOURNAME' )
    ) );

    $wp_customize->add_setting( 'cypress_social_twitter', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_twitter', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Twitter URL' ),
        'description' => __( 'E.g. https://twitter.com/YOURNAME' )
    ) );

    $wp_customize->add_setting( 'cypress_social_microblog', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_microblog', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Micro.blog URL' ),
        'description' => __( 'E.g. https://micro.blog/YOURNAME' )
    ) );

    $wp_customize->add_setting( 'cypress_social_instagram', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_instagram', array(
        'type' => 'text',
        'priority' => 30, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Instagram URL' ),
        'description' => __( 'E.g. https://instagram.com/YOURNAME' )
    ) );

    $wp_customize->add_setting( 'cypress_social_linkedin', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => '',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_social_linkedin', array(
        'type' => 'text',
        'priority' => 40, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'LinkedIn URL' ),
        'description' => __( 'E.g. https://linkedin.com/YOURNAME' )
    ) );



    
    // Footer Text
    $wp_customize->add_setting( 'cypress_footer_text', array(
        'type' => 'theme_mod', // or 'option'
        'capability' => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
        'default' => 'Website theme <a href="http://cdevroe.com/projects/cypress">Cypress on WordPress</a>.',
        'transport' => 'refresh', // or postMessage
        'sanitize_callback' => '',
        'sanitize_js_callback' => '' // Basically to_json.
    ) );

    $wp_customize->add_control( 'cypress_footer_text', array(
        'type' => 'text',
        'priority' => 50, // Within the section.
        'section' => 'cypress_theme_mods', // Required, core or custom.
        'label' => __( 'Footer Text' ),
        'description' => __( 'Shown at the bottom of each page.' ),
        'input_attrs' => array(
          'placeholder' => __( 'Powered by WordPress and coffee.' ),
        )
      ) );
}
add_action( 'customize_register', 'cypress_customize_register' );